/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FastIntegerSet
extends AbstractSet<Integer> {
    private final BitSet bitSet;
    private static final Iterator<Integer> EMPTY_ITERATOR = new Iterator<Integer>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Integer next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public FastIntegerSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    @Override
    public int size() {
        return this.bitSet.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        int index = (Integer)o;
        return this.bitSet.get(index);
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this.isEmpty()) {
            return EMPTY_ITERATOR;
        }
        return new Iterator<Integer>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                if (this.current == -1) {
                    return false;
                }
                this.current = FastIntegerSet.this.bitSet.nextSetBit(this.current);
                return this.current != -1;
            }

            @Override
            public Integer next() {
                if (this.current == -1) {
                    throw new NoSuchElementException();
                }
                this.current = FastIntegerSet.this.bitSet.nextSetBit(this.current);
                if (this.current == -1) {
                    throw new NoSuchElementException();
                }
                int next = this.current++;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(Integer integer) {
        int index = integer;
        if (this.bitSet.get(index)) {
            return false;
        }
        this.bitSet.set(index);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = (Integer)o;
        if (this.bitSet.get(index)) {
            this.bitSet.clear(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean containsAll = true;
        for (Object i : c) {
            int index = (Integer)i;
            if (this.bitSet.get(index)) continue;
            containsAll = false;
        }
        return containsAll;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        boolean modified = false;
        for (Integer n : c) {
            int index = n;
            if (this.bitSet.get(index)) continue;
            modified = true;
            this.bitSet.set(index);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }
}

