/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.protobuf.Descriptors;
import java.util.BitSet;
import java.util.Set;
import org.infinispan.protostream.impl.FastIntegerSet;

public class MessageContext<E extends MessageContext> {
    private final E parentContext;
    private final String fieldName;
    private String fullFieldName;
    private final Descriptors.Descriptor messageDescriptor;
    private final BitSet seenFields;
    private final FastIntegerSet seenFieldsSet;
    private int maxSeenFieldNumber = 0;

    public MessageContext(E parentContext, String fieldName, Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        if (parentContext != null && fieldName == null) {
            throw new IllegalArgumentException("fieldName cannot be null for nested contexts");
        }
        if (parentContext == null && fieldName != null) {
            throw new IllegalArgumentException("fieldName must be null for root contexts");
        }
        this.parentContext = parentContext;
        this.fieldName = fieldName;
        this.messageDescriptor = messageDescriptor;
        this.seenFields = new BitSet(messageDescriptor.getFields().size());
        this.seenFieldsSet = new FastIntegerSet(this.seenFields);
    }

    public E getParentContext() {
        return this.parentContext;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFullFieldName() {
        if (this.fieldName == null) {
            return null;
        }
        if (this.fullFieldName == null) {
            String pfqn = null;
            if (this.parentContext != null) {
                pfqn = ((MessageContext)this.parentContext).getFullFieldName();
            }
            this.fullFieldName = pfqn != null ? pfqn + "." + this.fieldName : this.fieldName;
        }
        return this.fullFieldName;
    }

    public Descriptors.Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public Descriptors.FieldDescriptor getFieldByName(String fieldName) {
        Descriptors.FieldDescriptor fd = this.messageDescriptor.findFieldByName(fieldName);
        if (fd == null) {
            throw new IllegalArgumentException("Unknown field : " + fieldName);
        }
        return fd;
    }

    public Descriptors.FieldDescriptor getFieldByNumber(int fieldNumber) {
        Descriptors.FieldDescriptor fd = this.messageDescriptor.findFieldByNumber(fieldNumber);
        if (fd == null) {
            throw new IllegalArgumentException("Unknown field : " + fieldNumber);
        }
        return fd;
    }

    public boolean isFieldMarked(int fieldNumber) {
        return this.seenFields.get(fieldNumber);
    }

    public boolean markField(int fieldNumber) {
        if (this.seenFields.get(fieldNumber)) {
            return false;
        }
        this.seenFields.set(fieldNumber);
        if (this.maxSeenFieldNumber < fieldNumber) {
            this.maxSeenFieldNumber = fieldNumber;
        }
        return true;
    }

    public int getMaxSeenFieldNumber() {
        return this.maxSeenFieldNumber;
    }

    @Deprecated
    public Set<Integer> getSeenFields() {
        return this.seenFieldsSet;
    }
}

