#!/bin/bash
if [ -f "/root/firstrun" ]
then
	echo "==================================================="
	echo "Setup the hostname of the server!"
	echo "==================================================="
	sleep 1
	echo ""
	echo -n "Enter the FQDN 			: "
	read NAME
	sleep 1
	echo ""
	echo ""
	echo "==================================================="
	echo "Ethernet device eth0 Configuration!"
	echo "==================================================="
	sleep 1
	echo ""
	echo -n "Enter the IP address		: "
	read IP
	sleep 1
	echo -n "Enter the subnet mask		: "
	read MASK
	sleep 1
	echo -n "Enter the gateway		: "
	read GATEWAY
	sleep 1
	echo -n "Enter the DNS IP		: "
	read DNS
	sleep 1
	echo ""
	echo ""
	echo "Are you sure everything is perfect now? (y/n): 	"
	read answer
	if [ $answer == y ]
	then
		# change hostname
		sed -i '/HOSTNAME/c\' /etc/sysconfig/network
		echo "HOSTNAME=$NAME" >> /etc/sysconfig/network
		hostname $NAME
		# Remove UUID
		sed -i '/UUID/c\' /etc/sysconfig/network-scripts/ifcfg-eth0

		#change Bootproto:
		sed -i '/BOOTPROTO/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "BOOTPROTO=static" >> /etc/sysconfig/network-scripts/ifcfg-eth0

		#change IP address:
		sed -i '/IPADDR/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "IPADDR=$IP" >> /etc/sysconfig/network-scripts/ifcfg-eth0

		# change netmask
		sed -i '/NETMASK/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "NETMASK=$MASK" >> /etc/sysconfig/network-scripts/ifcfg-eth0

		# change gateway
		sed -i '/GATEWAY/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "GATEWAY=$GATEWAY" >> /etc/sysconfig/network-scripts/ifcfg-eth0

		# change dns
		sed -i '/DNS1/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "DNS1=$DNS" >> /etc/sysconfig/network-scripts/ifcfg-eth0

		# change MAC
		MAC=`/sbin/ifconfig | grep 'eth0' | tr -s ' ' | cut -d ' ' -f5`
		sed -i '/HWADDR/c\' /etc/sysconfig/network-scripts/ifcfg-eth0
		echo "HWADDR=$MAC" >> /etc/sysconfig/network-scripts/ifcfg-eth0
		sleep 1
		# make the interface up and restart the service
		echo ""
		echo ""
		echo "Restarting the Network Service, please wait!"
		service network restart &> /dev/null
		sleep 1
		echo ""
		echo ""
		echo "Please Verify the IP Information and Hostname"
		echo ""
		echo ""
		echo "Hostname set is `hostname`"
		sleep 1
		echo ""
		echo "Output of ifconfig is as follows"
		echo "==================================================="
		ifconfig eth0
		echo "==================================================="
		echo "Moving the script so that it won't execute again!"
		rm -f /root/firstrun
		mv -f /root/update.sh /tmp
		echo "Backup created at /tmp with name update.sh"
	else
		bash /root/update.sh
	fi
fi
